# check_adj_fund_ratios.py
import pandas as pd, glob, re, os

adj = pd.read_csv("data/results/vol4_wilson_loop_adjoint_volume_sweep/adjoint_volume_summary.csv")

# Try to find a fundamental summary CSV
cands = []
for p in glob.glob("data/results/**/*.csv", recursive=True):
    name = os.path.basename(p).lower()
    if "fund" in name and "summary" in name:
        cands.append(p)

if not cands:
    raise SystemExit("No fundamental summary CSV found under data/results/**")

fund = pd.read_csv(cands[0])

# Try to normalize column names
def get_st(df, prefix=""):
    cols = df.columns.str.lower()
    if "string_tension" in cols.values:
        return df.rename(columns={"string_tension":"string_tension"+prefix})
    if "sigma" in cols.values and "l" in cols.values:
        out = df.copy()
        out["string_tension"+prefix] = out["sigma"] / (2*(out["L"]**2))
        return out
    raise SystemExit("Fundamental file missing 'string_tension' or 'sigma'.")

fund = get_st(fund, "_fund")
adj  = adj.rename(columns={"string_tension":"string_tension_adj"})

keys = ["L","b","gauge","k","n0"]
m = adj.merge(fund, on=keys, how="inner")
if m.empty:
    raise SystemExit("No overlap between adjoint and fundamental grids.")

m["ratio"] = m["string_tension_adj"]/m["string_tension_fund"]
print("mean ratio by gauge:")
print(m.groupby("gauge")["ratio"].mean())

print("\nby (L,gauge):")
print(m.groupby(["L","gauge"])["ratio"].mean())
